VERSION 5.00
Begin VB.Form frmU3800_Ext_SG_VCorrection 
   Caption         =   "U3800 External SG Vector Correction"
   ClientHeight    =   5235
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   5265
   BeginProperty Font 
      Name            =   "Arial"
      Size            =   9
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   ScaleHeight     =   5235
   ScaleWidth      =   5265
   StartUpPosition =   3  'Windows ̊l
   Begin VB.Frame FrmGPIB 
      Caption         =   "GPIB Address"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1215
      Left            =   360
      TabIndex        =   3
      Top             =   90
      Width           =   4695
      Begin VB.TextBox Txt_U38_GPIB_Address 
         Alignment       =   1  'E
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1041
            SubFormatType   =   1
         EndProperty
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         IMEMode         =   3  '̌Œ
         Left            =   3120
         TabIndex        =   6
         Top             =   750
         Width           =   405
      End
      Begin VB.TextBox Txt_SG_GPIB_Address 
         Alignment       =   1  'E
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1041
            SubFormatType   =   1
         EndProperty
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         IMEMode         =   3  '̌Œ
         Left            =   3120
         TabIndex        =   7
         Top             =   390
         Width           =   405
      End
      Begin VB.Label Lbl_U38_GPIB_Address 
         Caption         =   "U3800 GPIB Address"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   720
         TabIndex        =   4
         Top             =   750
         Width           =   1995
      End
      Begin VB.Label Lbl_SG_GPIB_Address 
         Caption         =   "    SG GPIB Address"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   750
         TabIndex        =   5
         Top             =   420
         Width           =   1995
      End
   End
   Begin VB.Frame FrmVCorr 
      Caption         =   "Vector Correction"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   3735
      Left            =   360
      TabIndex        =   0
      Top             =   1440
      Width           =   4695
      Begin VB.TextBox Txt_SG_Out_Level 
         Alignment       =   1  'E
         Height          =   330
         IMEMode         =   3  '̌Œ
         Left            =   3660
         TabIndex        =   20
         Top             =   2520
         Width           =   465
      End
      Begin VB.OptionButton Opt_VCorr_Type2 
         Caption         =   "InBand"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   315
         Left            =   2880
         TabIndex        =   18
         Top             =   390
         Width           =   1005
      End
      Begin VB.OptionButton Opt_VCorr_Type1 
         Caption         =   "Specific Span"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   150
         TabIndex        =   17
         Top             =   390
         Width           =   2085
      End
      Begin VB.CommandButton CmdVCorrAbort 
         Caption         =   "Abort"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   15.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   645
         Left            =   2850
         TabIndex        =   2
         Top             =   2970
         Width           =   1335
      End
      Begin VB.CommandButton CmdVCorrStart 
         Caption         =   "Start"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   15.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   645
         Left            =   600
         TabIndex        =   1
         Top             =   2970
         Width           =   1335
      End
      Begin VB.Label Label_Unit 
         Caption         =   "dBm"
         Height          =   225
         Left            =   4200
         TabIndex        =   21
         Top             =   2550
         Width           =   405
      End
      Begin VB.Label Label_SG_Output_Level 
         Caption         =   "SG Output Level"
         Height          =   285
         Left            =   2250
         TabIndex        =   19
         Top             =   2550
         Width           =   1395
      End
      Begin VB.Label Lbl_Count 
         Alignment       =   2  '
         Caption         =   "/"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   660
         TabIndex        =   16
         Top             =   2610
         Width           =   1275
      End
      Begin VB.Label Lbl_SG_Current_Freq 
         Alignment       =   1  'E
         BorderStyle     =   1  '
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   2250
         TabIndex        =   15
         Top             =   2130
         Width           =   2300
      End
      Begin VB.Label Label_SG_Current_Freq 
         Caption         =   "SG Current Frequency"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   180
         TabIndex        =   14
         Top             =   2160
         Width           =   2025
      End
      Begin VB.Label Lbl_SG_End_Freq 
         Alignment       =   1  'E
         BorderStyle     =   1  '
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   2250
         TabIndex        =   13
         Top             =   1680
         Width           =   2300
      End
      Begin VB.Label Lbl_SG_Step_Freq 
         Alignment       =   1  'E
         BorderStyle     =   1  '
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   2250
         TabIndex        =   12
         Top             =   1260
         Width           =   2300
      End
      Begin VB.Label Lbl_SG_Start_Freq 
         Alignment       =   1  'E
         BorderStyle     =   1  '
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   2250
         TabIndex        =   11
         Top             =   840
         Width           =   2300
      End
      Begin VB.Label Label_SG_End_Freq 
         Caption         =   "SG End Frequency "
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   180
         TabIndex        =   10
         Top             =   1710
         Width           =   2025
      End
      Begin VB.Label Label_SG_Step_Freq 
         Caption         =   "SG Step Frequency "
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   180
         TabIndex        =   9
         Top             =   1260
         Width           =   2025
      End
      Begin VB.Label Label_SG_Start_Freq 
         Caption         =   "SG Start Frequency "
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   180
         TabIndex        =   8
         Top             =   840
         Width           =   2025
      End
   End
End
Attribute VB_Name = "frmU3800_Ext_SG_VCorrection"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'************************************
'* Setting acquisition of a Textbox *
'************************************
Private Sub GetSetting()

    U38_GpibAddress = CLng(Txt_U38_GPIB_Address.Text)
    Call WriteIniFile_U38_GPIB_Adrs(Txt_U38_GPIB_Address.Text)
    
    SG_GpibAddress = CLng(Txt_SG_GPIB_Address.Text)
    Call WriteIniFile_SG_GPIB_Adrs(Txt_SG_GPIB_Address.Text)
    
    SG_OutputLevel = CSng(Txt_SG_Out_Level.Text)
    Call WriteIniFile_SG_OUT_LVL(Txt_SG_Out_Level.Text)
    
    If Opt_VCorr_Type1.value = True Then
        Call WriteIniFile_U38_VCorr_Type(Opt_VCorr_Type1.Caption)
    Else
        Call WriteIniFile_U38_VCorr_Type(Opt_VCorr_Type2.Caption)
    End If
    
End Sub

'***********************************************************
'* U3800 External SG Vector Correction Start               *
'*                                                         *
'* GPIB I/F                                                *
'*   National Instruments GPIB Interfaces                  *
'*                                                         *
'* E8257D (Agilent) PSG Analog Signal Generator            *
'*   GPIB (SCIPI) Command                                  *
'*   SG_OUTPUT__CMD = "OUTP "                              *
'*   SG_OUT_ON__CMD = "ON"                                 *
'*   SG_OUT_OFF_CMD = "OFF"                                *
'*   SG_OUT_LVL_CMD = "SOUR:POW "                          *
'*   SG_OUT_LVL_UNT = "DBM"                                *
'*   SG_SET_FRQ_CMD = "SOUR:FREQ "                         *
'*   SG_SET_FRQ_UNT = "HZ"                                 *
'*                                                         *
'***********************************************************
Private Sub CmdVCorrStart_Click()
    Dim err As Long
    Dim i As Long
    Dim buf As String
    Dim VCorr_TtlCnt As Long
    Dim strVCorr_TtlCnt As String
    Dim CentFreq As Double
    Dim OfstFreq As Double
    Dim strFreq As String
    
    Lbl_SG_Start_Freq.Caption = ""
    Lbl_SG_Step_Freq.Caption = ""
    Lbl_SG_End_Freq.Caption = ""
    Lbl_SG_Current_Freq.Caption = ""
    Lbl_Count.Caption = "/"
    
    Call GetSetting        ' U3800 & SG Setting acquisition of a Textbox.
    
    '*** GPIB ****
    GpibConnect = True
    If U38_GpibAddress > -1 And SG_GpibAddress > -1 And (U38_GpibAddress <> SG_GpibAddress) Then
     
        If OpenGpib(U38_GpibAddress) < 0 Then
            err = MsgBox("Can't open the GPIB address(" & CStr(U38_GpibAddress) & ").", vbOKOnly)
            GpibConnect = False
        End If
        If OpenGpib(SG_GpibAddress) < 0 Then
            err = MsgBox("Can't open the GPIB address(" & CStr(SG_GpibAddress) & ").", vbOKOnly)
            GpibConnect = False
        End If
    End If
    
    If GpibConnect = False Then Exit Sub
    
    err = PutGpib(U38_GpibAddress, "RFE")
    err = PutGpib(U38_GpibAddress, "VCSIGSRC EXT")          'SigSrc EXT
     
    err = QryGpib(U38_GpibAddress, "CF?", buf)
    If err < 0 Then
        err = MsgBox("CF? query command error.", vbOKOnly)
        GoTo GpibOffline
    End If
    
    CentFreq = CDbl(buf)
    strFreq = CStr(CentFreq)
    Lbl_SG_Current_Freq.Caption = strFreq
    err = PutGpib(SG_GpibAddress, SG_SET_FRQ_CMD & strFreq & SG_SET_FRQ_UNT)
    Lbl_SG_Start_Freq.Caption = buf
    
    'Set SG output on
    err = PutGpib(SG_GpibAddress, SG_OUT_ON__CMD)
    
    'Set SG output level
    err = PutGpib(SG_GpibAddress, SG_OUT_LVL_CMD & CStr(SG_OutputLevel) & SG_OUT_LVL_UNT)
    Call Sleep(500)
    
    VCorrAbort = False
    
    If Me.Opt_VCorr_Type1.value = True Then                     '*** Specific Span ***
    
        'Xmath 1.Power Ratio Phase Diff Execute ON/OFF
        err = QryGpib(U38_GpibAddress, "XPRPDON?", buf): i = CLng(buf)
        'Xmath 2.Differential Execute ON/OFF
        err = QryGpib(U38_GpibAddress, "XDIFFON?", buf): i = i + CLng(buf)
        'Xmath 4.Power Math Execute ON/OFF
        err = QryGpib(U38_GpibAddress, "XMATHON?", buf): i = i + CLng(buf)
        If i = 0 Then
            err = MsgBox("Xmath Function OFF.", vbOKOnly)
            GoTo GpibOffline
        End If

        err = PutGpib(U38_GpibAddress, "VCFSEXTINIT")           '     Initialize Specific Span external SG vector correction.
        err = QryGpib(U38_GpibAddress, "VCFSEXTSTPSZ?", buf)    '     Get Specific Span external SG vector correction total count.
        If err < 0 Then
            err = MsgBox("VCFSEXTSTPSZ? query command error.", vbOKOnly)
            Exit Sub
        End If
        VCorr_TtlCnt = CLng(buf)                                '     External SG vector correction total count.
        strVCorr_TtlCnt = CStr(VCorr_TtlCnt)
        
        err = QryGpib(U38_GpibAddress, "VCFA?", buf)            '     Start Freq.
        CentFreq = CDbl(buf)
        strFreq = CStr(CentFreq)
        err = PutGpib(SG_GpibAddress, SG_SET_FRQ_CMD & strFreq & SG_SET_FRQ_UNT)
        Call Sleep(1000)
        Lbl_SG_Start_Freq.Caption = buf
        err = QryGpib(U38_GpibAddress, "VCFB?", buf)            '     Stop  Freq.
        Lbl_SG_End_Freq.Caption = buf
        err = QryGpib(U38_GpibAddress, "VCFSTEP?", buf)         '     Step  Freq.
        Lbl_SG_Step_Freq.Caption = buf
    
        Lbl_Count.Caption = "0/" & strVCorr_TtlCnt
        Lbl_Count.Refresh
        
        For i = 1 To VCorr_TtlCnt
            If VCorrAbort = True Then Exit For
            err = PutGpib(U38_GpibAddress, "VCFSEXTIDX " & CStr(i))
            err = QryGpib(U38_GpibAddress, "CF?", buf)
            CentFreq = CDbl(buf)
            strFreq = CStr(CentFreq)
            Lbl_SG_Current_Freq.Caption = strFreq
            err = PutGpib(SG_GpibAddress, SG_SET_FRQ_CMD & strFreq & SG_SET_FRQ_UNT)
            Call Sleep(1000)
            err = PutGpib(U38_GpibAddress, "VCFSEXTEXE")
            Lbl_Count.Caption = CStr(i) & " / " & strVCorr_TtlCnt
            DoEvents
        Next i

        If VCorrAbort = False Then
            err = PutGpib(U38_GpibAddress, "VCFSEXTFINISH")     '     End Specific Span vector correction.
        Else
            err = PutGpib(U38_GpibAddress, "VCFSEXTABORT")      '     Abort Specific Span vector correction.
            err = PutGpib(U38_GpibAddress, "VCSIGSRC INT")      '     SigSrc INT
        End If
    Else                                                        '*** InBand ***
        err = PutGpib(U38_GpibAddress, "VCINBEXTINIT")          '     Initialize InBand external SG vector correction.
        err = QryGpib(U38_GpibAddress, "VCINBEXTSTPSZ?", buf)   '     Get InBand external SG vector correction total count.
        If err < 0 Then
            err = MsgBox("VCINBEXTSTPSZ? query command error.", vbOKOnly)
            Exit Sub
        End If
        VCorr_TtlCnt = CLng(buf)                                '     External SG vector correction total count.
        strVCorr_TtlCnt = CStr(VCorr_TtlCnt)
        
        Lbl_Count.Caption = "0/" & strVCorr_TtlCnt
        Lbl_Count.Refresh
        
        For i = 1 To VCorr_TtlCnt
            If VCorrAbort = True Then Exit For
            err = PutGpib(U38_GpibAddress, "VCINBEXTIDX " & CStr(i))
            err = QryGpib(U38_GpibAddress, "VCINBEXTFO?", buf)
            OfstFreq = CDbl(buf)
            err = QryGpib(U38_GpibAddress, "CF?", buf)
            CentFreq = CDbl(buf)
            strFreq = CStr(CentFreq + OfstFreq)
            Lbl_SG_Current_Freq.Caption = strFreq
            err = PutGpib(SG_GpibAddress, SG_SET_FRQ_CMD & strFreq & SG_SET_FRQ_UNT)
            Call Sleep(1000)
            err = PutGpib(U38_GpibAddress, "VCINBEXTEXE")
            Lbl_Count.Caption = CStr(i) & " / " & strVCorr_TtlCnt
            DoEvents
        Next i

        If VCorrAbort = False Then
            err = PutGpib(U38_GpibAddress, "VCINBEXTFINISH")    '     End InBand vector correction.
        Else
            err = PutGpib(U38_GpibAddress, "VCINBEXTABORT")     '     Abort InBand vector correction.
            err = PutGpib(U38_GpibAddress, "VCSIGSRC INT")      '     SigSrc INT
        End If
    End If
    
GpibOffline:
    Call CloseGpib(U38_GpibAddress)
    Call CloseGpib(SG_GpibAddress)

End Sub

'*********************************************
'* U3800 External SG Vector Correction Abort *
'*********************************************
Private Sub CmdVCorrAbort_Click()
    VCorrAbort = True
End Sub

'*************
'* Form load *
'*************
Private Sub Form_Load()

    VCorrAbort = False
    Call ClrGpibDd
    
    U38_GpibAddress = CLng(Trim(ReadIniFile_U38_GPIB_Adrs()))
    Txt_U38_GPIB_Address.Text = CStr(U38_GpibAddress)
    Call WriteIniFile_U38_GPIB_Adrs(Txt_U38_GPIB_Address.Text)

    SG_GpibAddress = CLng(Trim(ReadIniFile_SG_GPIB_Adrs()))
    Txt_SG_GPIB_Address.Text = CStr(SG_GpibAddress)
    Call WriteIniFile_SG_GPIB_Adrs(Txt_SG_GPIB_Address.Text)
    
    SG_OutputLevel = CSng(Trim(ReadIniFile_SG_OUT_LVL()))
    Txt_SG_Out_Level.Text = CStr(SG_OutputLevel)
    Call WriteIniFile_SG_OUT_LVL(Txt_SG_Out_Level.Text)
    
    If "Specific Span" = Trim(ReadIniFile_U38_VCorr_Type()) Then
        Opt_VCorr_Type1.value = True
        Opt_VCorr_Type2.value = False
        Call WriteIniFile_U38_VCorr_Type(Opt_VCorr_Type1.Caption)
    Else
        Opt_VCorr_Type1.value = False
        Opt_VCorr_Type2.value = True
        Call WriteIniFile_U38_VCorr_Type(Opt_VCorr_Type2.Caption)
    End If

    SG_OUTPUT__CMD = Trim(ReadIniFile_SG_OUT_STS_Cmd())
    Call WriteIniFile_SG_OUT_STS_Cmd(SG_OUTPUT__CMD)
    
    SG_OUT_ON__CMD = Trim(ReadIniFile_SG_OUT_ON_Para())
    Call WriteIniFile_SG_OUT_ON_Para(SG_OUT_ON__CMD)
    SG_OUT_ON__CMD = SG_OUTPUT__CMD & " " & SG_OUT_ON__CMD
    
    SG_OUT_OFF_CMD = Trim(ReadIniFile_SG_OUT_OFF_Para())
    Call WriteIniFile_SG_OUT_OFF_Para(SG_OUT_OFF_CMD)
    SG_OUT_OFF_CMD = SG_OUTPUT__CMD & " " & SG_OUT_OFF_CMD
    
    SG_OUT_LVL_CMD = Trim(ReadIniFile_SG_OUT_LVL_Cmd())
    Call WriteIniFile_SG_OUT_LVL_Cmd(SG_OUT_LVL_CMD)
    SG_OUT_LVL_CMD = SG_OUT_LVL_CMD & " "
    
    SG_OUT_LVL_UNT = Trim(ReadIniFile_SG_OUT_LVL_Unit())
    Call WriteIniFile_SG_OUT_LVL_Unit(SG_OUT_LVL_UNT)
    
    SG_SET_FRQ_CMD = Trim(ReadIniFile_SG_Freq_Cmd())
    Call WriteIniFile_SG_Freq_Cmd(SG_SET_FRQ_CMD)
    SG_SET_FRQ_CMD = SG_SET_FRQ_CMD & " "
    
    SG_SET_FRQ_UNT = Trim(ReadIniFile_SG_Freq_Unit())
    Call WriteIniFile_SG_Freq_Unit(SG_SET_FRQ_UNT)
    
End Sub
